<?php

require_once ('common.php');
require_once ('config.php');

$current_image = custom_get('image');
$position = 0;

// get images from directory

$position = get_images($cfg['img_directory'], $current_image);

// generate menu of images

$menu = '';
foreach($images as $image)
   {
   $menu .= "<li><a href=\"?image=$image\">$image</a></li>\n";
   }

// default to first image if no image selected

if ($current_image == '')
   {
   $current_image = $images[1];
   $position = 1;
   }

// generate next/previous controls

$next_image = '<a href="#">';
$total_images = sizeof($images);

$controls = "<a href=\"$_SERVER[PHP_SELF]?image=$images[1]\" title = \"Start\">&lt; Start | </a>";

if ($position > 1)
   {
   $image = $images[$position - 1];
   $controls .= "<a href=\"$_SERVER[PHP_SELF]?image=$image\" title=\"Previous\">&lt;&lt; Prev | </a>";
   }
else
   {
   $controls .= "&lt;&lt; Prev | ";
   }   

if ($position < $total_images)
   {
   $image = $images[$position + 1];
   $controls .= "<a href=\"$_SERVER[PHP_SELF]?image=$image\" title=\"Next\">Next &gt;&gt;</a>";
   $next_image = "<a href=\"$_SERVER[PHP_SELF]?image=$image\">";
   }
else
   {
   $controls .= "Next &gt;&gt;";
   }   

$controls .= "<a href=\"$_SERVER[PHP_SELF]?image=$images[$total_images]\" title = \"End\">  | End &gt;</a>";

   
// generate html

$tpl = & new Template();
$tpl->set('controls',$controls);
$tpl->set('site_name',$cfg['site_name']);
$tpl->set('album_name',$cfg['album_name']);
$tpl->set('next_image',$next_image);
$tpl->set('current_image',$current_image);
$tpl->set('images',$images);
$main_content = $tpl->fetch('templates/index.tpl');

// generate master template

$tpl2 = & new Template();
$tpl2->set('main_content',$main_content);
$tpl2->set('site_slogan',$cfg['site_slogan']);
$tpl2->set('site_name',$cfg['site_name']);
$tpl2->set('title',$cfg['album_name']);
$tpl2->set('menu',$menu);
$x = $tpl2->fetch('templates/master.tpl');

echo $x;

// get images function

function get_images($directory, $current_image)
{

// only select image type files

global $images;

$index = 1;
$images = array();
$position = 0;

$fp = opendir($directory);
while ($filename = readdir($fp))
   {
   if ($filename != "." && $filename != "..")
      {
      if (preg_match("/(\.gif|\.jpg|\.jpeg|\.bmp|\.png)$/", strtolower($filename)))
         { 
         if ($filename == $current_image)
            {
            $position = $index;
            }
         $images[$index] = $filename;
         $index++;
         } 
	    }
   }
closedir($fp);

return ($position);

}

?>
